package bluetooth.Trump;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.Button;
import android.widget.TextView;
import android.view.Gravity;
import android.view.ViewGroup;
import android.widget.ImageView;



public class Image extends Activity {
	private final int FP = ViewGroup.LayoutParams.FILL_PARENT; 
	private final int WC = ViewGroup.LayoutParams.WRAP_CONTENT; 
	
	int spade[] = new int[14];
	int heart[] = new int[14];
	int dia[] = new int[14];
	int clover[] = new int[14];
	int cardback = 0;
	int playerHandCounter = 1; //D̃J[ĥ炵ɎgJE^@
	int enemyHandCounter = 1; //
	
	/** Called with the activity is first created. */
	@Override
	public void onCreate(Bundle icicle)
	{
		super.onCreate(icicle);

		imagemapping();	//`z摜ɑΉt
//		show(new ViewInfo(),1); //摜\[gĕ\
		result(new ViewInfo(),1); //player1łꍇ̌ʕ\
	}
	
	private FrameLayout.LayoutParams createEnemyParam(int w, int h){ //Dzû߂̃p[^
		FrameLayout.LayoutParams fl = new FrameLayout.LayoutParams(w, h);
		fl.leftMargin = 27*enemyHandCounter;
		enemyHandCounter++;
		return fl;
	}
	
	private FrameLayout.LayoutParams CreateMyParam(int w, int h){ //Dzû߂̃p[^
		FrameLayout.LayoutParams fl = new FrameLayout.LayoutParams(w, h);
		fl.leftMargin = 27*playerHandCounter;
		playerHandCounter++;
		return fl;
	}
	
    private LinearLayout.LayoutParams createLinearParam(int w, int h){ //linearLayout̊{p[^
        return new LinearLayout.LayoutParams(w, h);
    }
    
    
    
	public void show(ViewInfo viewinfo, int playernumber){ //S̕\n
		 LinearLayout Layout = new LinearLayout(this);
			Layout.setGravity(Gravity.CENTER_HORIZONTAL);
			Layout.setOrientation(LinearLayout.VERTICAL);
		    
		    FrameLayout enemy = enemycount(viewinfo, playernumber);
		    
		    ViewGroup parent1 = (ViewGroup)enemy.getParent(); 
		    if ( parent1 != null ) {
		        parent1.removeView(enemy);
		    }

		    LinearLayout button = buttonLayout();
		    
		    ViewGroup parent2 = (ViewGroup)button.getParent(); 
		    if ( parent2 != null ) {
		        parent2.removeView(button);
		    }
			
			FrameLayout hand = handsort(viewinfo, playernumber);
		    
		    ViewGroup parent3 = (ViewGroup)hand.getParent();
		    if ( parent3 != null ) {
		        parent3.removeView(hand);
		    }//layout̓q̍ۂɕKvȏ
		    
		    
		    
		    LinearLayout.LayoutParams marginEdit = createLinearParam(WC, WC);
		    marginEdit.topMargin = 200;//GDƃ{^C{^ƎD̃CAEg
		    
		    Layout.addView(enemy, createLinearParam(WC, WC));
		    Layout.addView(button, marginEdit);
		    Layout.addView(hand, marginEdit);
		    
		    setContentView(Layout);
	}
    
	
	
	public void result(ViewInfo viewinfo, int playernumber){ //S̕\n
		 LinearLayout Layout = new LinearLayout(this);
			Layout.setGravity(Gravity.CENTER_HORIZONTAL);
			Layout.setOrientation(LinearLayout.VERTICAL);
		    
		    FrameLayout enemy = handsort(viewinfo, (3-playernumber));
		    
		    ViewGroup parent1 = (ViewGroup)enemy.getParent(); 
		    if ( parent1 != null ) {
		        parent1.removeView(enemy);
		    }

		    LinearLayout button = buttonLayout();
		    
		    ViewGroup parent2 = (ViewGroup)button.getParent(); 
		    if ( parent2 != null ) {
		        parent2.removeView(button);
		    }
			
			FrameLayout hand = handsort(viewinfo, playernumber);
		    
		    ViewGroup parent3 = (ViewGroup)hand.getParent();
		    if ( parent3 != null ) {
		        parent3.removeView(hand);
		    }//layout̓q̍ۂɕKvȏ
		    
		    
		    
		    LinearLayout.LayoutParams marginEdit = createLinearParam(WC, WC);
		    marginEdit.topMargin = 200;//GDƃ{^C{^ƎD̃CAEg
		    
		    Layout.addView(enemy, createLinearParam(WC, WC));
		    Layout.addView(button, marginEdit);
		    Layout.addView(hand, marginEdit);
		    
		    setContentView(Layout);
	}
	
	
    
	public FrameLayout enemycount(ViewInfo viewinfo, int playernumber){ //̎DJEgĕ\
		
		FrameLayout enemyhand = new FrameLayout(this);
		
		int enemyCardNumber = 0;//̎D imagemappingɓ

		int spade[] = viewinfo.getSpade();
		int heart[] = viewinfo.getHeart();
		int dia[] = viewinfo.getDia();
		int clover[] = viewinfo.getClover();
		
		for(int i=1;i<14;i++){
			if(spade[i] == (3-playernumber)){
				enemyCardNumber++;
			}


			if(heart[i] == (3-playernumber)){
				enemyCardNumber++;
			}


			if(dia[i] == (3-playernumber)){
				enemyCardNumber++;
			}


			if(clover[i] == (3-playernumber)){
				enemyCardNumber++;
			}
		}
		
		for(int i=1;i<enemyCardNumber;i++){ //(̎D-1)̗ԂJ[hׂ
			ImageView enemycard = new ImageView(this);
			enemycard.setImageResource(cardback);
			enemyhand.addView(enemycard, createEnemyParam(WC, WC));
		}
		
		
		ImageView enemyOpenCard = new ImageView(this);
		
		
		for(int i=1;i<14;i++){
			if(spade[i] == (0-(3-playernumber))){
				enemyOpenAdd('s', i, enemyhand);
			}

			if(heart[i] == (0-(3-playernumber))){
				enemyOpenAdd('h', i, enemyhand);
			}

			if(dia[i] == (0-(3-playernumber))){
				enemyOpenAdd('d', i, enemyhand);
			}

			if(clover[i] == (0-(3-playernumber))){
				enemyOpenAdd('c', i, enemyhand);
			}
		}
		
		enemyHandCounter = 1;
			
		return enemyhand;
	}
	
	
	public void enemyOpenAdd(char mark, int number, FrameLayout enemyhand){
		ImageView enemyOpenCard = new ImageView(this);
		
		switch(mark){
		case 's':
			enemyOpenCard.setImageResource(spade[number]);
			enemyhand.addView(enemyOpenCard, createEnemyParam(WC, WC));
			break;
			
		case 'h':
			enemyOpenCard.setImageResource(heart[number]);
			enemyhand.addView(enemyOpenCard, createEnemyParam(WC, WC));
			break;
			
		case 'd':
			enemyOpenCard.setImageResource(dia[number]);
			enemyhand.addView(enemyOpenCard, createEnemyParam(WC, WC));
			break;
			
		default:
			enemyOpenCard.setImageResource(clover[number]);
			enemyhand.addView(enemyOpenCard, createEnemyParam(WC, WC));
		}

	}
	
	
	
	public LinearLayout buttonLayout(){ //CȂ{^̔zu
		LinearLayout bl = new LinearLayout(this);
		
	    LinearLayout.LayoutParams buttonMargin = createLinearParam(WC, WC);
	    buttonMargin.leftMargin = 200;//GDƃ{^C{^ƎD̃CAEg
	    
	    Button draw = new Button(this);
	    draw.setText("");
	    Button ndraw = new Button(this);
	    ndraw.setText("Ȃ");
		
	    bl.addView(draw, createLinearParam(WC, WC));
	    bl.addView(ndraw, buttonMargin);
		
		return bl;
		
	}


	/*D*/
	public FrameLayout handsort(ViewInfo viewinfo,int playernumber){ //D𐮗ĕ\

		//D̐錾
		FrameLayout hand = new FrameLayout(this);
//		hand.setGravity(Gravity.BOTTOM);
//		hand.setGravity(Gravity.CENTER_HORIZONTAL);
//	    hand.setOrientation(LinearLayout.HORIZONTAL);
		setContentView(hand);
		
		int spade[] = viewinfo.getSpade();
		int heart[] = viewinfo.getHeart();
		int dia[] = viewinfo.getDia();
		int clover[] = viewinfo.getClover();

		/*珸ɕׂ*/

		for(int i=1;i<14;i++){
			if(spade[i] == playernumber){
				imageshow('s', i, hand);
			}


			if(heart[i] == playernumber){
				imageshow('h', i, hand);
			}


			if(dia[i] == playernumber){
				imageshow('d', i, hand);
			}


			if(clover[i] == playernumber){
				imageshow('c', i, hand);
			}
		}
		
		
		ImageView myOpenCard = new ImageView(this);
		
		
		for(int i=1;i<14;i++){
			if(spade[i] == (0-playernumber)){
				myOpenAdd('s', i, hand);
			}

			if(heart[i] == (0-playernumber)){
				myOpenAdd('h', i, hand);
			}

			if(dia[i] == (0-playernumber)){
				myOpenAdd('d', i, hand);
			}

			if(clover[i] == (0-playernumber)){
				myOpenAdd('c', i, hand);
			}
		}
		
		playerHandCounter = 1;
		
		return hand;
	}
	
	
	public void myOpenAdd(char mark, int number, FrameLayout enemyhand){
		ImageView myOpenCard = new ImageView(this);
		

			FrameLayout.LayoutParams fl = new FrameLayout.LayoutParams(WC, WC);
			fl.leftMargin = (27*playerHandCounter+200);
		
		switch(mark){
		case 's':
			myOpenCard.setImageResource(spade[number]);
			enemyhand.addView(myOpenCard, fl);
			break;
			
		case 'h':
			myOpenCard.setImageResource(heart[number]);
			enemyhand.addView(myOpenCard, fl);
			break;
			
		case 'd':
			myOpenCard.setImageResource(dia[number]);
			enemyhand.addView(myOpenCard, fl);
			break;
			
		default:
			myOpenCard.setImageResource(clover[number]);
			enemyhand.addView(myOpenCard, fl);
		}

	}

	

	public void imageshow(char mark, int number, FrameLayout hand){
		

		ImageView card = new ImageView(this);
		
		switch(mark){
		case 's':
			card.setImageResource(spade[number]);
			hand.addView(card, CreateMyParam(WC, WC));
			break;
			
		case 'h':
			card.setImageResource(heart[number]);
			hand.addView(card, CreateMyParam(WC, WC));
			break;
			
		case 'd':
			card.setImageResource(dia[number]);
			hand.addView(card, CreateMyParam(WC, WC));
			break;
			
		default:
			card.setImageResource(clover[number]);
			hand.addView(card, CreateMyParam(WC, WC));
		}
	}
	
	
	
	public void imagemapping(){ //摜int^zɑΉt郁\bh
		for(int i=1; i<10; i++){
			spade[i] = this.getResources().getIdentifier("s0"+(i+1), "drawable", this.getPackageName());
		}

		for(int i=10; i<14; i++){
			spade[i] = this.getResources().getIdentifier("s"+(i+1), "drawable", this.getPackageName());
		}
		
		
		for(int i=1; i<10; i++){
			heart[i] = this.getResources().getIdentifier("h0"+(i+1), "drawable", this.getPackageName());
		}

		for(int i=10; i<14; i++){
			heart[i] = this.getResources().getIdentifier("h"+(i+1), "drawable", this.getPackageName());
		}
		
		
		for(int i=1; i<10; i++){
			dia[i] = this.getResources().getIdentifier("d0"+(i+1), "drawable", this.getPackageName());
		}

		for(int i=10; i<14; i++){
			dia[i] = this.getResources().getIdentifier("d"+(i+1), "drawable", this.getPackageName());
		}
		
		
		for(int i=1; i<10; i++){
			clover[i] = this.getResources().getIdentifier("c0"+(i+1), "drawable", this.getPackageName());
		}

		for(int i=10; i<14; i++){
			clover[i] = this.getResources().getIdentifier("c"+(i+1), "drawable", this.getPackageName());
		}
		
		cardback = this.getResources().getIdentifier("z01", "drawable", this.getPackageName()); //Ԃ̃J[h
	}
}